/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.bogey_menu;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.railwayteam.railways.api.bogeymenu.v0.entry.BogeyEntry;
import com.railwayteam.railways.api.bogeymenu.v0.entry.CategoryEntry;
import com.railwayteam.railways.content.bogey_menu.components.BogeyMenuButton;
import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuHandlerClient;
import com.railwayteam.railways.impl.bogeymenu.v0.BogeyMenuManagerImpl;
import com.railwayteam.railways.registry.CRGuiTextures;
import com.railwayteam.railways.registry.CRIcons;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.client.ClientTextUtils;
import com.railwayteam.railways.util.packet.BogeyStyleSelectionPacket;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.gui.widget.TooltipArea;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BogeyMenuScreen
extends AbstractSimiScreen {
    private final CRGuiTextures background = CRGuiTextures.BOGEY_MENU;
    private final List<class_2561> categoryComponentList = BogeyMenuManagerImpl.CATEGORIES.stream().map(CategoryEntry::getName).toList();
    private CategoryEntry selectedCategory = BogeyMenuManagerImpl.CATEGORIES.get(0);
    private int categoryIndex = 0;
    BogeyEntry[] bogeyList = new BogeyEntry[6];
    BogeyMenuButton[] bogeyMenuButtons = new BogeyMenuButton[6];
    BogeyEntry selectedBogey;
    private float scrollOffs;
    private boolean scrolling;
    private int ticksOpen;
    private boolean soundPlayed;
    private TooltipArea longBogeyTooltipArea;
    private IconButton favouriteButton;

    protected void method_25426() {
        this.setWindowSize(this.background.width, this.background.height);
        super.method_25426();
        this.method_37067();
        int x = this.guiLeft;
        int y = this.guiTop;
        for (int i = 0; i < 6; ++i) {
            this.bogeyMenuButtons[i] = new BogeyMenuButton(x + 19, y + 41 + i * 18, 82, 17, this.bogeySelection(i));
            this.method_37063((class_364)this.bogeyMenuButtons[i]);
        }
        this.setupList(this.selectedCategory);
        this.selectedBogey = this.selectedCategory.getBogeyEntryList().get(0);
        this.scrollOffs = 0.0f;
        this.scrollTo(0.0f);
        Label categoryLabel = new Label(x + 14, y + 25, class_5244.field_39003).withShadow();
        ScrollInput categoryScrollInput = new SelectionScrollInput(x + 9, y + 20, 77, 18).forOptions(this.categoryComponentList).writingTo(categoryLabel).setState(this.categoryIndex).calling(categoryIndex -> {
            this.scrollOffs = 0.0f;
            this.scrollTo(0.0f);
            this.categoryIndex = categoryIndex;
            this.selectedCategory = BogeyMenuManagerImpl.CATEGORIES.get((int)categoryIndex);
            this.setupList(this.selectedCategory);
            this.selectedBogey = !this.selectedCategory.getBogeyEntryList().isEmpty() ? this.selectedCategory.getBogeyEntryList().get(0) : null;
        });
        this.method_37063((class_364)categoryLabel);
        this.method_37063((class_364)categoryScrollInput);
        this.favouriteButton = new IconButton(x + this.background.width - 167, y + this.background.height - 49, (ScreenElement)CRIcons.I_FAVORITE);
        this.favouriteButton.withCallback(this::onFavorite);
        this.method_37063((class_364)this.favouriteButton);
        IconButton closeButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        closeButton.withCallback(this::onMenuClose);
        this.method_37063((class_364)closeButton);
        String[] gaugeText = new String[]{"narrow", "standard", "wide"};
        for (int i = 0; i < 3; ++i) {
            this.method_37060((class_4068)new TooltipArea(x + 163 + i * 18, y + 135, 18, 18).withTooltip((List)ImmutableList.of((Object)class_2561.method_43471((String)"railways.gui.bogey_menu.gauge_description").method_27694(s -> s.method_36139(5476833)), (Object)class_2561.method_43471((String)("railways.gui.bogey_menu." + gaugeText[i] + "_gauge")).method_27692(class_124.field_1080))));
        }
        this.longBogeyTooltipArea = new TooltipArea(x + 122, y + 20, 136, 18);
        this.method_37060((class_4068)this.longBogeyTooltipArea);
    }

    protected void renderWindow(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        class_4587 ms = guiGraphics.method_51448();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(guiGraphics, x, y, 512, 512);
        class_5250 header = class_2561.method_43471((String)"railways.gui.bogey_menu.title");
        int halfWidth = this.background.width / 2;
        int halfHeaderWidth = this.field_22793.method_27525((class_5348)header) / 2;
        guiGraphics.method_51439(this.field_22793, (class_2561)header, x + halfWidth - halfHeaderWidth, y + 4, 5776420, false);
        ms.method_22903();
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((class_4587)ms).pushPose().translate((float)(x + this.background.width + 4), (float)(y + this.background.height + 4), 100.0f).scale(40.0f)).rotateXDegrees(-22.0f)).rotateYDegrees(63.0f);
        GuiGameElement.of((class_2680)AllBlocks.RAILWAY_CASING.getDefaultState()).render(guiGraphics);
        ms.method_22909();
        int scrollBarPos = (int)(41.0f + 93.0f * this.scrollOffs);
        CRGuiTextures barTexture = this.canScroll() ? CRGuiTextures.BOGEY_MENU_SCROLL_BAR : CRGuiTextures.BOGEY_MENU_SCROLL_BAR_DISABLED;
        barTexture.render(guiGraphics, x + 11, y + scrollBarPos, 512, 512);
        for (int i = 0; i < 6; ++i) {
            BogeyEntry bogeyEntry = this.bogeyList[i];
            if (bogeyEntry == null) continue;
            class_2960 icon = bogeyEntry.iconLocation();
            if (icon != null) {
                this.renderIcon(guiGraphics, ms, icon, x + 20, y + 42 + i * 18);
            }
            class_2561 bogeyName = ClientTextUtils.getComponentWithWidthCutoff(bogeyEntry.bogeyStyle().displayName, 55);
            guiGraphics.method_27535(this.field_22793, bogeyName, x + 40, y + 46 + i * 18, 0xFFFFFF);
        }
        if (this.selectedBogey != null) {
            class_2561 displayName = this.selectedBogey.bogeyStyle().displayName;
            class_2561 bogeyName = ClientTextUtils.getComponentWithWidthCutoff(displayName, 126);
            guiGraphics.method_27534(this.field_22793, bogeyName, x + 190, y + 25, 0xFFFFFF);
            if (this.field_22793.method_27525((class_5348)displayName) > 126) {
                this.longBogeyTooltipArea.withTooltip((List)ImmutableList.of((Object)displayName));
                this.longBogeyTooltipArea.field_22764 = true;
            } else {
                this.longBogeyTooltipArea.field_22764 = false;
            }
            Indicator.State[] states = BogeyMenuHandlerClient.getTrackCompat(this.selectedBogey);
            for (int i = 0; i < 3; ++i) {
                AllGuiTextures indicator = switch (states[i]) {
                    default -> throw new IncompatibleClassChangeError();
                    case Indicator.State.ON -> AllGuiTextures.INDICATOR_WHITE;
                    case Indicator.State.OFF -> AllGuiTextures.INDICATOR;
                    case Indicator.State.RED -> AllGuiTextures.INDICATOR_RED;
                    case Indicator.State.YELLOW -> AllGuiTextures.INDICATOR_YELLOW;
                    case Indicator.State.GREEN -> AllGuiTextures.INDICATOR_GREEN;
                };
                indicator.render(guiGraphics, x + 163 + i * 18, y + 128);
            }
            BogeyStyle style = this.selectedBogey.bogeyStyle();
            float bogeyScale = this.selectedBogey.scale();
            List<Pair<BogeyStyle, BogeySizes.BogeySize>> renderCycle = BogeyMenuHandlerClient.getRenderCycle(style);
            Pair<BogeyStyle, BogeySizes.BogeySize> renderPair = renderCycle.get(this.ticksOpen / 40 % renderCycle.size());
            BogeyStyle renderStyle = (BogeyStyle)renderPair.getFirst();
            BogeySizes.BogeySize renderSize = (BogeySizes.BogeySize)renderPair.getSecond();
            if (BogeyMenuManagerImpl.SIZES_TO_SCALE.containsKey(renderPair)) {
                bogeyScale = BogeyMenuManagerImpl.SIZES_TO_SCALE.get(renderPair).floatValue();
            }
            AbstractBogeyBlock bogeyBlock = style.getBlockForSize(renderSize);
            class_2680 bogeyState = (class_2680)bogeyBlock.method_9564().method_11657((class_2769)AbstractBogeyBlock.AXIS, (Comparable)class_2350.class_2351.field_11051);
            float defaultScale = 23.0f;
            float scalePercentage = bogeyScale / defaultScale;
            ms.method_22903();
            class_4587 modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.method_22903();
            modelViewStack.method_46416(18.0f * scalePercentage, 6.0f * scalePercentage, 0.0f);
            modelViewStack.method_22904((double)x + 189.5, (double)(y + 86), 1500.0);
            modelViewStack.method_22905(1.0f, 1.0f, -1.0f);
            RenderSystem.applyModelViewMatrix();
            ms.method_46416(0.0f, 0.0f, 1000.0f);
            ms.method_22905(bogeyScale, bogeyScale, bogeyScale);
            Quaternionf zRot = class_7833.field_40718.rotationDegrees(180.0f);
            Quaternionf xRot = class_7833.field_40714.rotationDegrees(-20.0f);
            Quaternionf yRot = class_7833.field_40716.rotationDegrees(45.0f);
            zRot.mul((Quaternionfc)xRot);
            zRot.mul((Quaternionfc)yRot);
            ms.method_22907(zRot);
            class_308.method_34742();
            class_310 mc = class_310.method_1551();
            class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
            int light = 0xF000F0;
            int overlay = class_4608.field_21444;
            float wheelAngle = -3.0f * AnimationTickHolder.getRenderTime();
            this.field_22787.method_1541().method_3353(bogeyState, ms, (class_4597)bufferSource, light, overlay);
            ms.method_22903();
            ms.method_46416(0.0f, 0.0f, 1.0f);
            renderStyle.render(renderSize, partialTicks, ms, (class_4597)bufferSource, light, overlay, wheelAngle, new class_2487(), false);
            ms.method_22909();
            bufferSource.method_22993();
            modelViewStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            ms.method_22909();
            double x0 = x + 120;
            double y0 = y + 48;
            double w = 140.0;
            double h = 77.0;
            double bottom = y0 + h;
            class_1041 window = mc.method_22683();
            double scale = window.method_4495();
            RenderSystem.clearDepth((double)0.86);
            RenderSystem.enableScissor((int)((int)(x0 * scale)), (int)(window.method_4506() - (int)(bottom * scale)), (int)((int)(w * scale)), (int)((int)(h * scale)));
            RenderSystem.clear((int)256, (boolean)false);
            RenderSystem.disableScissor();
            RenderSystem.clearDepth((double)1.0);
        }
    }

    private void renderIcon(class_332 guiGraphics, class_4587 ms, class_2960 icon, int x, int y) {
        ms.method_22903();
        guiGraphics.method_25291(icon, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        ms.method_22909();
    }

    private void setupList(CategoryEntry categoryEntry) {
        this.setupList(categoryEntry, 0);
    }

    private void setupList(CategoryEntry categoryEntry, int offset) {
        List<BogeyEntry> bogies = categoryEntry.getBogeyEntryList();
        for (int i = 0; i < 6; ++i) {
            if (i < bogies.size()) {
                this.bogeyList[i] = bogies.get(i + offset);
                this.bogeyMenuButtons[i].field_22763 = true;
                continue;
            }
            this.bogeyList[i] = null;
            this.bogeyMenuButtons[i].field_22763 = false;
        }
    }

    public void method_25393() {
        ++this.ticksOpen;
        this.soundPlayed = false;
        super.method_25393();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.selectedBogey == null) {
                this.method_25419();
            } else {
                this.onMenuClose();
            }
            return true;
        }
        if (keyCode == 257) {
            this.onMenuClose();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.insideScrollbar(mouseX, mouseY)) {
            this.scrolling = this.canScroll();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.scrolling) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        int scrollbarLeft = this.guiTop + 41;
        int scrollbarRight = scrollbarLeft + 108;
        float scrollFactor = (float)((mouseY - (double)scrollbarLeft - 7.5) / (double)((float)(scrollbarRight - scrollbarLeft) - 15.0f));
        this.scrollOffs = class_3532.method_15363((float)scrollFactor, (float)0.0f, (float)1.0f);
        this.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        super.method_25401(mouseX, mouseY, delta);
        if (!this.canScroll()) {
            return false;
        }
        if (this.insideCategorySelector(mouseX, mouseY)) {
            return false;
        }
        if (this.selectedCategory.getBogeyEntryList().size() < 6) {
            return false;
        }
        double listSize = this.selectedCategory.getBogeyEntryList().size() - 6;
        float scrollFactor = (float)(delta / listSize);
        float oldScrollOffs = this.scrollOffs;
        this.scrollOffs = class_3532.method_15363((float)(this.scrollOffs - scrollFactor), (float)0.0f, (float)1.0f);
        this.scrollTo(this.scrollOffs);
        if (!this.soundPlayed && this.scrollOffs != oldScrollOffs) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * this.scrollOffs)));
        }
        this.soundPlayed = true;
        return true;
    }

    private void scrollTo(float pos) {
        List<BogeyEntry> bogies = this.selectedCategory.getBogeyEntryList();
        float listSize = bogies.size() - 6;
        int index = (int)((double)(pos * listSize) + 0.5);
        this.setupList(this.selectedCategory, index);
    }

    private boolean canScroll() {
        return this.selectedCategory.getBogeyEntryList().size() > 6;
    }

    private boolean insideCategorySelector(double mouseX, double mouseY) {
        int scrollbarLeftX = this.guiLeft + 11;
        int scrollbarTopY = this.guiTop + 20;
        int scrollbarRightX = scrollbarLeftX + 90;
        int scrollbarBottomY = scrollbarTopY + 34;
        return mouseX >= (double)scrollbarLeftX && mouseY >= (double)scrollbarTopY && mouseX < (double)scrollbarRightX && mouseY < (double)scrollbarBottomY;
    }

    private boolean insideScrollbar(double mouseX, double mouseY) {
        int scrollbarLeftX = this.guiLeft + 11;
        int scrollbarTopY = this.guiTop + 41;
        int scrollbarRightX = scrollbarLeftX + 8;
        int scrollbarBottomY = scrollbarTopY + 108;
        return mouseX >= (double)scrollbarLeftX && mouseY >= (double)scrollbarTopY && mouseX < (double)scrollbarRightX && mouseY < (double)scrollbarBottomY;
    }

    private class_4185.class_4241 bogeySelection(int index) {
        return b -> {
            this.selectedBogey = this.bogeyList[index];
            this.updateFavorites();
        };
    }

    private void onFavorite() {
        if (this.selectedBogey != null) {
            BogeyMenuHandlerClient.toggleFavorite(this.selectedBogey.bogeyStyle());
            this.updateFavorites();
        }
    }

    private void updateFavorites() {
        this.favouriteButton.setIcon((ScreenElement)(BogeyMenuHandlerClient.isFavorited(this.selectedBogey.bogeyStyle()) ? CRIcons.I_FAVORITED : CRIcons.I_FAVORITE));
        if (this.selectedCategory == CategoryEntry.FavoritesCategory.INSTANCE) {
            this.scrollTo(this.scrollOffs);
        }
    }

    private void onMenuClose() {
        if (this.selectedBogey == null) {
            return;
        }
        BogeyStyle style = this.selectedBogey.bogeyStyle();
        BogeySizes.BogeySize size = BogeyMenuHandlerClient.getSize(style);
        CRPackets.PACKETS.send(new BogeyStyleSelectionPacket(style, size));
        this.method_25419();
    }
}

